// Top Secret Crypto Gold for Windows
//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Procedures for editing the individual keys in a key ring.
//..........................................................
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include "Tscmsg.h"
#include "Check.h"
#define STRSAFE_LIB
#include <strsafe.h>

extern	DWORD		dwStringSafeFlag;
extern	LPCD_STRUCT	lpScratchCentralDir;
extern	DWORD		MarkType;
extern	int			iItemsSelected;
extern	int			iMaxItems;
extern	int			iItemCount;
extern	HWND		hEditListWindow;
extern	BOOL		bSingleSelectionOnly;
extern	DWORD		dwCDLength;
extern	LPCTSTR		lpIconPointer;
extern	LPCTSTR		lpszAppName;
extern	HINSTANCE	hInst;
extern	CONFIG		cfg;
extern	TCHAR		szTscPath[MAX_PATH];
extern	LPCTSTR		lpszNullString;

DWORD	dwTip;
DWORD	dwTipString;
DWORD	dwTipHelp;

// Values for our temporary registry entries for file icons.
//..........................................................
LPCTSTR	lpszRSA1 = ".rsakey";
LPCTSTR	lpszRSA2 = "rsakey";
LPCTSTR	lpszRSA3 = "RSA Key File";
LPCTSTR lpszRSA4 = "3";
BOOL	bRemoveRsa = FALSE;

LPCTSTR	lpszOTP1 = ".otp";
LPCTSTR	lpszOTP2 = "otpfile";
LPCTSTR	lpszOTP3 = "One Time Pad Key File";
LPCTSTR lpszOTP4 = "4";
BOOL	bRemoveOtp = FALSE;

LPCTSTR	lpszPad1 = ".pad";
LPCTSTR	lpszPad2 = "padfile";
LPCTSTR	lpszPad3 = "True One Time Pad File";
LPCTSTR lpszPad4 = "8";
BOOL	bRemovePad = FALSE;

LPCTSTR	lpszPkd1 = ".pkd";
LPCTSTR	lpszPkd2 = "packedfile";
LPCTSTR	lpszPkd3 = "Packed File";
LPCTSTR lpszPkd4 = "7";
BOOL	bRemovePkd = FALSE;

LPCTSTR	lpszR641 = ".r64";
LPCTSTR	lpszR642 = "r64emailfile";
LPCTSTR	lpszR643 = "Tsc Transformed E-mail File";
LPCTSTR lpszR644 = "6";
BOOL	bRemoveR64 = FALSE;

LPCTSTR	lpszRbb1 = ".rbb";
LPCTSTR	lpszRbb2 = "rbbfile";
LPCTSTR	lpszRbb3 = "Random Bits Bin File";
LPCTSTR lpszRbb4 = "5";
BOOL	bRemoveRbb = FALSE;

LPCTSTR	lpszRng1 = ".rng";
LPCTSTR lpszRng2 = "ringfile";
LPCTSTR lpszRng3 = "RSA Key Ring File";
LPCTSTR lpszRng4 = "1";
BOOL	bRemoveRng = FALSE;

LPCTSTR lpszTsc1 = ".tsc";
LPCTSTR lpszTsc2 = "encryptedfile";
LPCTSTR lpszTsc3 = "Tsc Encrypted File";
LPCTSTR lpszTsc4 = "2";
BOOL	bRemoveTsc = FALSE;

LPCTSTR lpszSig1 = ".tsig";
LPCTSTR lpszSig2 = "signaturefile";
LPCTSTR lpszSig3 = "Tsc Signature File";
LPCTSTR lpszSig4 = "9";
BOOL	bRemoveSig = FALSE;

LPCTSTR lpszJrl1 = ".jrl";
LPCTSTR lpszJrl2 = "tscjournal";
LPCTSTR lpszJrl3 = "Tsc Encrypted Journal";
LPCTSTR lpszJrl4 = "10";
BOOL	bRemoveJrl = FALSE;

TCHAR	szIconDllFile[MAX_PATH];
LPCTSTR lpszDefIcon = "\\DefaultIcon";
LPCTSTR	lpszIconFileName = "TscgIcon.dll,";

// Handle the WM_NOTIFY message for the virtual list view window
// in our edit key ring procedures.
//..............................................................
LRESULT EditListViewNotify(HWND hWnd, LPNMHDR lpNmhdr)
{
	LPNMLVDISPINFO		lpLvdi;
	int					iIndex;
	int					iFirstIndex;
	int					iLastIndex;
	int					iFirstMark;
	int					iLastMark;
	int					iFocus;
	int					iFocused;
	int					iFirstUnmarked;
	int					iLastUnmarked;
	BOOL				bContinuous;
	LPCD_STRUCT			lpCentralDir;
	LPCD_STRUCT			lpLastItem;
	LPNMLISTVIEW		lpnmListView;
	BOOL				bCtrlKey;
	BOOL				bAltKey;
	BOOL				bShiftKey;
	BOOL				bReturn = 0;
	int					i;
	int					iLastItem;
	int					iSelectedItems;
	SHORT				sTemp;

	bCtrlKey = FALSE;
	bAltKey = FALSE;
	bShiftKey = FALSE;

	// Determine the keys pressed during the selection.
	//.................................................
	sTemp = GetKeyState(VK_CONTROL);
	if (sTemp & 0x8000)
	{
		bCtrlKey = TRUE;
	}
	sTemp = GetKeyState(VK_SHIFT);
	if (sTemp & 0x8000)
	{
		bShiftKey = TRUE;
	}
	sTemp = GetKeyState(VK_MENU);
	if (sTemp & 0x8000)
	{
		bAltKey = TRUE;
	}
	
	switch (lpNmhdr->code)
	{
		case LVN_GETDISPINFO:
		{
			lpLvdi = (LPNMLVDISPINFO)lpNmhdr;

			// Determine the index of the item we need to give
			// information about and calculate its address in 
			// the Central Directory.
			//................................................
			iIndex = lpLvdi->item.iItem;
			__asm
			{
				mov		eax,iIndex
				mov		ecx,dwCDLength
				mul		ecx
				add		eax,lpScratchCentralDir
				mov		lpCentralDir,eax
			}
			// Fill in the image imformation for the first column.
			//....................................................
			if (lpLvdi->item.mask & LVIF_IMAGE)
			{
				lpLvdi->item.iImage = lpCentralDir->iImageIdx;
			}
			// Fill in the items state.
			//.........................
			if (lpLvdi->item.mask & LVIF_STATE)
			{
				lpLvdi->item.state = lpCentralDir->STATE;
			}
			// Fill in the text for the item and subitems.
			//............................................
			if (lpLvdi->item.mask & LVIF_TEXT)
			{
				switch(lpLvdi->item.iSubItem)
				{
					case 0:
					{
						// Copy the type of entry.
						//........................
						StringCbCopy(lpLvdi->item.pszText,lpLvdi->item.cchTextMax,
									 lpCentralDir->KEY_TYPE);
					}
					break;

					case 1:
					{
						// Copy the number of bits.
						//.........................
						StringCbCopy(lpLvdi->item.pszText,lpLvdi->item.cchTextMax,
									 lpCentralDir->BITS);
					}
					break;

					case 2:
					{
						// Copy the Key ID.
						//.................
						StringCbCopy(lpLvdi->item.pszText,lpLvdi->item.cchTextMax,
									 lpCentralDir->KEY_SIG_ID_C);
					}
					break;

					case 3:
					{
						// Copy the date.
						//...............
						StringCbCopy(lpLvdi->item.pszText,lpLvdi->item.cchTextMax,
									 lpCentralDir->DATE);
					}
					break;

					case 4:
					{
						// Copy disabled state.
						//.....................
						StringCbCopy(lpLvdi->item.pszText,lpLvdi->item.cchTextMax,
									 lpCentralDir->DISABLED);
					}
					break;

					case 5:
					{
						// Copy the user or sig id.
						//.........................
						StringCbCopy(lpLvdi->item.pszText,lpLvdi->item.cchTextMax,
									 lpCentralDir->ID);
					}
					break;

					default:
						break;
				}
			}
		}
		break;

		// Handle left mouse button clicks.
		//.................................
		case NM_CLICK:
		{
			lpnmListView = (LPNMLISTVIEW)lpNmhdr;

			// Determine the index of the item.
			//.................................
			iIndex = lpnmListView->iItem;

			// Check to see if we have a click on an invalid area.
			//....................................................
			if (iIndex == -1)
			{
				// Unmark all the items and set the first selectable item
				// as focused.
				//.......................................................
				for (i = 0; i < iItemCount; i++)
				{
					__asm
					{
						mov		eax,i
						mov		ecx,dwCDLength
						mul		ecx
						add		eax,lpScratchCentralDir
						mov		lpCentralDir,eax
					}
					if (lpCentralDir->STATE)
					{
						lpCentralDir->STATE = 0;
						SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)i,0);
					}
				}
				// Set the focus on the first item that can be selected.
				//......................................................
				if (MarkType == MARK_KEYS)
				{
					lpScratchCentralDir->STATE = LVIS_FOCUSED;
					i = 0;
				}
				else
				{
					lpCentralDir = lpScratchCentralDir;
					i = 0;

					while(TRUE)
					{
						if (lpCentralDir->TYPE_KEY == SIG_PACKET)
						{
							break;
						}
						__asm
						{
							mov		eax,lpCentralDir
							add		eax,dwCDLength
							mov		lpCentralDir,eax
						}
						i++;
					}
					lpCentralDir->STATE = LVIS_FOCUSED;
				}
				// Update the key or signature.
				//.............................
				SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)i,0);
				iItemsSelected = 0;
			}
			// Process the single selection for the secret key ring
			// when selecting a secret key to sign or encrypt with.
			//......................................................
			else if (bSingleSelectionOnly)
			{
				// Find the item that is focused or selected and focused.
				//.......................................................
				for (i = 0; i < iItemCount; i++)
				{
					__asm
					{
						mov		eax,i
						mov		ecx,dwCDLength
						mul		ecx
						add		eax,lpScratchCentralDir
						mov		lpCentralDir,eax
					}
					if (lpCentralDir->STATE)
					{
						break;
					}
				}
				if (bCtrlKey && bAltKey)
				{
					// Unmark the selection and place the focus on the first item.
					//............................................................
					lpCentralDir->STATE = 0;
					SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)i,0);
					i = 0;
					lpScratchCentralDir->STATE = LVIS_FOCUSED;
					SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)i,0);
					iItemsSelected = 0;
				}
				else if (i == iIndex && bCtrlKey)
				{
					// Toggle the state of the item.
					//..............................
					lpCentralDir->STATE ^= LVIS_SELECTED;
					SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)i,0);
					if (iItemsSelected == 0)
					{
						iItemsSelected = 1;
					}
					else
					{
						iItemsSelected = 0;
					}
				}
				// If the shift or just alt keys are pressed, skip them.
				//......................................................
				else if (bShiftKey || bAltKey)
				{
					break;
				}
				else
				{
					// Get the key or signature we have selected.
					//...........................................
					__asm
					{
						mov		eax,iIndex
						mov		ecx,dwCDLength
						mul		ecx
						add		eax,lpScratchCentralDir
						mov		lpCentralDir,eax
					}
					// We only process sigs or keys depending on what we are
					// working with.
					//......................................................
					if	((MarkType == MARK_SIGS && lpCentralDir->TYPE_KEY == SIG_PACKET) ||
						(MarkType == MARK_KEYS && lpCentralDir->TYPE_KEY <= SECRET_KEY))
					{
						// Normal selection. Unselect and unfocus the selected item.
						//..........................................................
						for (i = 0; i < iItemCount; i++)
						{
							__asm
							{
								mov		eax,i
								mov		ecx,dwCDLength
								mul		ecx
								add		eax,lpScratchCentralDir
								mov		lpCentralDir,eax
							}
							if (lpCentralDir->STATE)
							{
								lpCentralDir->STATE = 0;
								SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)i,0);
								break;
							}
						}
						// Mark the newly selected item as selected and focused.
						//......................................................
						iItemsSelected = 1;

						__asm
						{
							mov		eax,iIndex
							mov		ecx,dwCDLength
							mul		ecx
							add		eax,lpScratchCentralDir
							mov		lpCentralDir,eax
						}
						lpCentralDir->STATE = (LVIS_SELECTED | LVIS_FOCUSED);
						SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)iIndex,0);
					}
				}
			}
			else
			{
				// Handle multiple selections. Handle the unmark all procedure. 
				//.............................................................
				if (bCtrlKey && bAltKey)
				{
					if (iItemsSelected)
					{
						for (i = 0; i < iItemCount; i++)
						{
							__asm
							{
								mov		eax,i
								mov		ecx,dwCDLength
								mul		ecx
								add		eax,lpScratchCentralDir
								mov		lpCentralDir,eax
							}
							// Only unmark an item if it is marked.
							//.....................................
							if (lpCentralDir->STATE)
							{
								lpCentralDir->STATE = 0;
								SendMessage(hEditListWindow,LVM_UPDATE,
										   (WPARAM)i,0);
							}
						}
						iItemsSelected = 0;
						
						// Set the focus on the first item that can be selected.
						//......................................................
						if (MarkType == MARK_KEYS)
						{			
							lpScratchCentralDir->STATE = LVIS_FOCUSED;
							i = 0;
						}
						else
						{
							lpCentralDir = lpScratchCentralDir;
							i = 0;

							while(TRUE)
							{
								if (lpCentralDir->TYPE_KEY == SIG_PACKET)
								{
									break;
								}
								__asm
								{
									mov		eax,lpCentralDir
									add		eax,dwCDLength
									mov		lpCentralDir,eax
								}
								i++;
							}
							lpCentralDir->STATE = LVIS_FOCUSED;
						}
						// Update the key or signature.
						//.............................
						SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)i,0);
					}
				}
				// Handle the mark all procedure.
				//...............................
				else if (bAltKey)
				{
					// If the maximum numer of items is already
					// selected, return.
					//.........................................
					if (iItemsSelected == iMaxItems)
					{
						break;
					}
					iSelectedItems = 0;

					for (i = 0; i < iItemCount; i++)
					{
						__asm
						{
							mov		eax,i
							mov		ecx,dwCDLength
							mul		ecx
							add		eax,lpScratchCentralDir
							mov		lpCentralDir,eax
						}
						if (MarkType == MARK_SIGS &&
							lpCentralDir->TYPE_KEY != SIG_PACKET)
						{
							continue;
						}
						if (MarkType == MARK_KEYS &&
							lpCentralDir->TYPE_KEY == SIG_PACKET)
						{
							continue;
						}
						// Set the last item variables.
						//.............................
						iLastItem = i;
						iSelectedItems++;
						lpLastItem = lpCentralDir;

						// Only mark an item if it is not marked.
						//.......................................
						if (!lpCentralDir->STATE)
						{
							lpCentralDir->STATE = LVIS_SELECTED;
							SendMessage(hEditListWindow,LVM_UPDATE,
									   (WPARAM)i,0);
						}
						// If we have one with the focus set, unset it.
						//.............................................
						if (lpCentralDir->STATE & LVIS_FOCUSED)
						{
							lpCentralDir->STATE = LVIS_SELECTED;
							SendMessage(hEditListWindow,LVM_UPDATE,
									   (WPARAM)i,0);
						}
					}
					// Set the focus on the last item.
					//................................
					lpLastItem->STATE = (LVIS_SELECTED | LVIS_FOCUSED);
					SendMessage(hEditListWindow,LVM_UPDATE,
								(WPARAM)iLastItem,0);
					iItemsSelected = iSelectedItems;
				}
				// If we have a shift key on sigs just ignore it.
				//...............................................
				else if (bShiftKey && MarkType == MARK_SIGS)
				{
					break;
				}
				// Handle the mark a range of keys procedure.
				// This is not for signatures
				//...........................................
				else if (bShiftKey && MarkType == MARK_KEYS)
				{
					// See if we have clicked on a key.
					//.................................
					__asm
					{
						mov		eax,iIndex
						mov		ecx,dwCDLength
						mul		ecx
						add		eax,lpScratchCentralDir
						mov		lpCentralDir,eax
					}
					if (lpCentralDir->TYPE_KEY == SIG_PACKET)
					{
						break;
					}
					// From here on we have clicked on a key.
					// If no items selected just mark the item.
					//.........................................
					if (iItemsSelected == 0)
					{
						// Find the item with the focus and remove it.
						//............................................
						lpCentralDir = lpScratchCentralDir;

						for (i = 0; i < iItemCount; i++)
						{
							if (lpCentralDir->STATE)
							{
								lpCentralDir->STATE = 0;
								SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)i,0);
								break;
							}
							__asm
							{
								mov		eax,dwCDLength
								add		lpCentralDir,eax
							}
						}
						// Mark the selected key.
						//.......................
						__asm
						{
							mov		eax,iIndex
							mov		ecx,dwCDLength
							mul		ecx
							add		eax,lpScratchCentralDir
							mov		lpCentralDir,eax
						}
						lpCentralDir->STATE = LVIS_SELECTED | LVIS_FOCUSED;
						SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)iIndex,0);
						iItemsSelected++;
					}
					else
					{
						// More than one item selected.
						//.............................
						iFirstIndex = -1;
						iFocused = -1;
						bContinuous = TRUE;
						iFirstUnmarked = -1;

						for (i = 0; i < iItemCount; i++)
						{
							__asm
							{
								mov		eax,i
								mov		ecx,dwCDLength
								mul		ecx
								add		eax,lpScratchCentralDir
								mov		lpCentralDir,eax
							}
							if (lpCentralDir->TYPE_KEY <= SECRET_KEY)
							{
								if (lpCentralDir->STATE & LVIS_SELECTED)
								{
									if (iFirstIndex == -1)
									{
										iFirstIndex = i;
									}
									iLastIndex = i;
								}
								else
								{
									if (iFirstUnmarked == -1)
									{
										iFirstUnmarked = i;
									}
									iLastUnmarked = i;
								}
								if (lpCentralDir->STATE & LVIS_FOCUSED)
								{
									iFocused = i;
								}
							}
						}
						// See if we have a continuous block.
						//...................................
						if ((iFirstUnmarked > iFirstIndex && iFirstUnmarked < iLastIndex) ||
							(iLastUnmarked < iLastIndex && iLastUnmarked > iFirstIndex))
						{
							bContinuous = FALSE;
						}
						// Setup a default range.
						//.......................
						iFirstMark = iFirstIndex;
						iLastMark = iLastIndex;
						iFocus = iFocused;

						if (bContinuous)
						{
							// Determine how to mark the items.
							//.................................
							if (iFocused == iLastIndex && iIndex > iLastIndex)
							{
								iLastMark = iIndex;
								iFocus = iIndex;
							}
							else if (iFocused == iFirstIndex && iIndex < iFirstIndex)
							{
								iFirstMark = iIndex;
								iFocus = iIndex;
							}
							else if (iFocused == iLastIndex && iIndex < iFirstIndex)
							{
								iFirstMark = iIndex;
								iFocus = iIndex;
								iLastMark = iFirstIndex;
							}
							else if (iFocused == iFirstIndex && iIndex > iLastIndex)
							{
								iFirstMark = iLastIndex;
								iLastMark = iIndex;
								iFocus = iIndex;
							}
							else if (iIndex < iFocused && iIndex >= iFirstIndex)
							{
								iLastMark = iIndex;
								iFocus = iIndex;
							}
							else if (iIndex > iFocused && iIndex <= iLastIndex)
							{
								iFirstMark = iIndex;
								iFocus = iIndex;
							}
						}
						else
						{
							// We do not have a continuous band of marked items.
							// We mark from the focus to the selected item.
							//..................................................
							if (iIndex < iFocused)
							{
								iFirstMark = iIndex;
								iFocus = iIndex;
								iLastMark = iFocused;
							}
							else if (iIndex > iFocused)
							{
								iLastMark = iIndex;
								iFocus = iIndex;
								iFirstMark = iFocused;
							}
							else
							{
								iFirstMark = iIndex;
								iLastMark = iIndex;
								iFocus = iIndex;
							}
						}
						// Display the marked items if there has been a change.
						//.....................................................
						if (iFirstMark != iFirstIndex || iLastMark != iLastIndex || iFocus != iFocused)
						{
							// First remove the focus.
							//........................
							for (i = 0; i < iItemCount; i++)
							{
								__asm
								{
									mov		eax,i
									mov		ecx,dwCDLength
									mul		ecx
									add		eax,lpScratchCentralDir
									mov		lpCentralDir,eax
								}
								if (lpCentralDir->STATE & LVIS_FOCUSED)
								{
									lpCentralDir->STATE ^= LVIS_FOCUSED;
									SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)i,0);
									break;
								}
							}
							// Now mark the items.
							//....................
							iItemsSelected = 0;

							for (i = 0; i < iItemCount; i++)
							{
								__asm
								{
									mov		eax,i
									mov		ecx,dwCDLength
									mul		ecx
									add		eax,lpScratchCentralDir
									mov		lpCentralDir,eax
								}
								if (lpCentralDir->TYPE_KEY <= SECRET_KEY)
								{
									// If the item is outside the range and marked,
									// unmark it.
									//.............................................
									if ((i < iFirstMark || i > iLastMark) && lpCentralDir->STATE)
									{
										lpCentralDir->STATE = 0;
										SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)i,0);
									}
									else if ((i >= iFirstMark && i <= iLastMark) && lpCentralDir->STATE == 0)
									{
										lpCentralDir->STATE = LVIS_SELECTED;
										SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)i,0);
									}
								}
							}
							// Set the focus.
							//...............
							__asm
							{
								mov		eax,iFocus
								mov		ecx,dwCDLength
								mul		ecx
								add		eax,lpScratchCentralDir
								mov		lpCentralDir,eax
							}
							lpCentralDir->STATE |= LVIS_FOCUSED;
							SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)iFocus,0);

							// Find the total number of selected items.
							//.........................................
							iItemsSelected = 0;
							for (i = 0; i < iItemCount; i++)
							{
								__asm
								{
									mov		eax,i
									mov		ecx,dwCDLength
									mul		ecx
									add		eax,lpScratchCentralDir
									mov		lpCentralDir,eax
								}
								if (lpCentralDir->STATE & LVIS_SELECTED)
								{
									iItemsSelected++;
								}
							}
						}
					}
				}
				// Handle the mark one item at a time procedure.
				// If the control key is pressed mark the key if
				// it is not already selected and change focus.
				//..............................................
				else if (bCtrlKey)
				{
					// If no items selected just mark the item.
					//.........................................
					if (iItemsSelected == 0)
					{
						// Find the item with the focus and remove it.
						//............................................
						lpCentralDir = lpScratchCentralDir;
						i = 0;

						while(TRUE)
						{
							if (lpCentralDir->STATE & LVIS_FOCUSED)
							{
								lpCentralDir->STATE = 0;
								SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)i,0);
								break;
							}
							__asm
							{
								mov		eax,dwCDLength
								add		lpCentralDir,eax
							}
							i++;
						}
						// Mark the selected item.
						//........................
						__asm
						{
							mov		eax,iIndex
							mov		ecx,dwCDLength
							mul		ecx
							add		eax,lpScratchCentralDir
							mov		lpCentralDir,eax
						}
						if	(((MarkType == MARK_SIGS && 
							lpCentralDir->TYPE_KEY == SIG_PACKET) ||
							(MarkType == MARK_KEYS &&
							lpCentralDir->TYPE_KEY <= SECRET_KEY)) &&
							lpCentralDir->STATE == 0)
						{
							lpCentralDir->STATE = LVIS_SELECTED | LVIS_FOCUSED;
							SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)iIndex,0);
							iItemsSelected++;
						}
					}
					else
					{
						// Get the selected item.
						//.......................
						__asm
						{
							mov		eax,iIndex
							mov		ecx,dwCDLength
							mul		ecx
							add		eax,lpScratchCentralDir
							mov		lpCentralDir,eax
						}
						if	(((MarkType == MARK_SIGS && 
							lpCentralDir->TYPE_KEY == SIG_PACKET) ||
							(MarkType == MARK_KEYS &&
							lpCentralDir->TYPE_KEY <= SECRET_KEY)) &&
						    (lpCentralDir->STATE == 0))
						{
							// We have a valid item to mark. Find the 
							// one with the focus and just change it 
							// to selected.
							//.......................................
							for (i = 0; i < iItemCount; i++)
							{
								__asm
								{
									mov		eax,i
									mov		ecx,dwCDLength
									mul		ecx
									add		eax,lpScratchCentralDir
									mov		lpLastItem,eax
								}
								if (lpLastItem->STATE & LVIS_FOCUSED)
								{

									lpLastItem->STATE = LVIS_SELECTED;
									SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)i,0);
									break;
								}
							}
							// Now mark the newly selected item.
							//..................................
							lpCentralDir->STATE = LVIS_SELECTED | LVIS_FOCUSED;
							SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)iIndex,0);
							iItemsSelected++;
						}
						else if (((MarkType == MARK_SIGS && 
								 lpCentralDir->TYPE_KEY == SIG_PACKET) ||
								 (MarkType == MARK_KEYS &&
								  lpCentralDir->TYPE_KEY <= SECRET_KEY)) &&
								 (lpCentralDir->STATE & LVIS_SELECTED))
						{
							// We have a selected item. Unselect it.
							//......................................
							lpCentralDir->STATE = 0;
							SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)iIndex,0);
							iItemsSelected--;

							// If there are no items now selected, set the focus on
							// the first selectable item.
							//.....................................................
							if (iItemsSelected == 0)
							{
								// Set the focus on the first item that can be selected.
								//......................................................
								if (MarkType == MARK_KEYS)
								{			
									lpScratchCentralDir->STATE = LVIS_FOCUSED;
									i = 0;
								}
								else
								{
									lpCentralDir = lpScratchCentralDir;
									i = 0;

									while(TRUE)
									{
										if (lpCentralDir->TYPE_KEY == SIG_PACKET)
										{
											break;
										}
										__asm
										{
											mov		eax,lpCentralDir
											add		eax,dwCDLength
											mov		lpCentralDir,eax
										}
										i++;
									}
									lpCentralDir->STATE = LVIS_FOCUSED;
								}
								// Update the key or signature.
								//.............................
								SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)i,0);
							}
							else
							{
								// We have one or more selected. Set the focus
								// on the last item, or if we have one with the
								// focus already set, leave it along.
								//.............................................
								for (i = 0; i < iItemCount; i++)
								{
									__asm
									{
										mov		eax,i
										mov		ecx,dwCDLength
										mul		ecx
										add		eax,lpScratchCentralDir
										mov		lpCentralDir,eax
									}
									if (lpCentralDir->STATE)
									{
										iLastItem = i;
										lpLastItem = lpCentralDir;
										if (lpLastItem->STATE & LVIS_FOCUSED)
										{
											break;
										}
									}
								}
								// Set the focus on the appropriate item.
								//.......................................
								lpLastItem->STATE = (LVIS_SELECTED | LVIS_FOCUSED);
								SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)iLastItem,0);
							}
						}
					}
				}
				else
				{
					// Normal individual selection. One selection kills
					// all the others.
					__asm
					{
						mov		eax,iIndex
						mov		ecx,dwCDLength
						mul		ecx
						add		eax,lpScratchCentralDir
						mov		lpCentralDir,eax
					}
					// First unmark any selected items.
					//.................................
					if	((MarkType == MARK_SIGS && lpCentralDir->TYPE_KEY == SIG_PACKET) ||
						(MarkType == MARK_KEYS && lpCentralDir->TYPE_KEY <= SECRET_KEY))
					{
						for (i = 0; i < iItemCount; i++)
						{
							__asm
							{
								mov		eax,i
								mov		ecx,dwCDLength
								mul		ecx
								add		eax,lpScratchCentralDir
								mov		lpLastItem,eax
							}
							if (lpLastItem->STATE)
							{
								lpLastItem->STATE = 0;
								SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)i,0);
							}
						}
						// Mark the item.
						//...............
						lpCentralDir->STATE = LVIS_SELECTED | LVIS_FOCUSED;
						SendMessage(hEditListWindow,LVM_UPDATE,(WPARAM)iIndex,0);
						iItemsSelected = 1;
					}
				}
			}
		}
		break;

		case LVN_KEYDOWN:
		{
			LPNMLVKEYDOWN		lpKdn;

			lpKdn = (LPNMLVKEYDOWN)lpNmhdr;

			switch (lpKdn->wVKey)
			{
				case VK_ESCAPE:
				{
					iItemsSelected = 0;
					SendMessage(hWnd,WM_CLOSE,0,0);
					bReturn = TRUE;
				}
				break;
			}
		}
		break;

		// These two messages are not currently used by the program.
		//..........................................................
		case LVN_ODCACHEHINT:
        case LVN_ODFINDITEM:
			break;

		default:
			break;
	}
	return(bReturn);
}

// CALLBACK procedure for TSCG tips dialog box.
//.............................................
LRESULT CALLBACK TscgTipProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	BOOL		bChecked;
	TCHAR		szTip[1024];
	TCHAR		szTip1[1024];

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);

			// Set the text of the edit box.
			//..............................
			LoadString(hInst,dwTipString,(LPTSTR)&szTip,sizeof(szTip));
			FormatMessage(FORMAT_MESSAGE_FROM_STRING | FORMAT_MESSAGE_IGNORE_INSERTS,
						  &szTip,0,0,(LPTSTR)&szTip1,sizeof(szTip1),NULL);
			SetDlgItemText(hDlg,IDC_TIPEDIT,(LPCTSTR)&szTip1);

			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			SetFocus(GetDlgItem(hDlg,IDC_MYYES));
			return(FALSE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_TIPASK:
				{
					// Get the state of the checkbox.
					//...............................
					bChecked = !IsDlgButtonChecked(hDlg,IDC_TIPASK);
					CheckDlgButton(hDlg,IDC_TIPASK,bChecked ? MF_CHECKED : MF_UNCHECKED);
				}
				break;

				case IDCANCEL:
				case IDOK:
				{	
					// Get the value for the checkbox.
					//................................
					bChecked = IsDlgButtonChecked(hDlg,IDC_TIPASK);
					if (bChecked)
					{
						cfg.dwTips ^= dwTip;
					}
					EndDialog(hDlg,IDOK);
				}
				break;
				
				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
			break;
		}
		
		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Setup the registry entries for the file icons.
//...............................................
BOOL SetupRegistryEntries()
{
	BOOL		bResult = FALSE;

	if (!SetRegistryEntry(lpszRSA1,lpszRSA2,lpszRSA3,lpszRSA4,&bRemoveRsa))
	{
		goto SetRegEnd;
	}
	if (!SetRegistryEntry(lpszOTP1,lpszOTP2,lpszOTP3,lpszOTP4,&bRemoveOtp))
	{
		goto SetRegEnd;
	}
	if (!SetRegistryEntry(lpszPad1,lpszPad2,lpszPad3,lpszPad4,&bRemovePad))
	{
		goto SetRegEnd;
	}
	if (!SetRegistryEntry(lpszPkd1,lpszPkd2,lpszPkd3,lpszPkd4,&bRemovePkd))
	{
		goto SetRegEnd;
	}
	if (!SetRegistryEntry(lpszR641,lpszR642,lpszR643,lpszR644,&bRemoveR64))
	{
		goto SetRegEnd;
	}
	if (!SetRegistryEntry(lpszRbb1,lpszRbb2,lpszRbb3,lpszRbb4,&bRemoveRbb))
	{
		goto SetRegEnd;
	}
	if (!SetRegistryEntry(lpszRng1,lpszRng2,lpszRng4,lpszRng4,&bRemoveRng))
	{
		goto SetRegEnd;
	}
	if (!SetRegistryEntry(lpszTsc1,lpszTsc2,lpszTsc3,lpszTsc4,&bRemoveTsc))
	{
		goto SetRegEnd;
	}
	if (!SetRegistryEntry(lpszSig1,lpszSig2,lpszSig3,lpszSig4,&bRemoveSig))
	{
		goto SetRegEnd;
	}
	if (!SetRegistryEntry(lpszJrl1,lpszJrl2,lpszJrl3,lpszJrl4,&bRemoveJrl))
	{
		goto SetRegEnd;
	}
	bResult = TRUE;

	SetRegEnd:

	return(bResult);
}

// Remove the registry entries since this is not our computer.
//............................................................
VOID RemoveRegistryEntries()
{
	DeleteRegistryEntry(lpszRSA1,lpszRSA2,bRemoveRsa);
	DeleteRegistryEntry(lpszOTP1,lpszOTP2,bRemoveOtp);
	DeleteRegistryEntry(lpszPad1,lpszPad2,bRemovePad);
	DeleteRegistryEntry(lpszPkd1,lpszPkd2,bRemovePkd);
	DeleteRegistryEntry(lpszR641,lpszR642,bRemoveR64);
	DeleteRegistryEntry(lpszRbb1,lpszRbb2,bRemoveRbb);
	DeleteRegistryEntry(lpszRng1,lpszRng2,bRemoveRng);
	DeleteRegistryEntry(lpszTsc1,lpszTsc2,bRemoveTsc);
	DeleteRegistryEntry(lpszSig1,lpszSig2,bRemoveSig);
	DeleteRegistryEntry(lpszJrl1,lpszJrl2,bRemoveJrl);
}

// Set a registry entry.
//......................
BOOL SetRegistryEntry(LPCTSTR lpSubKey, LPCTSTR lpValue1, LPCTSTR lpValue2,
					  LPCTSTR lpIconNumber, LPBOOL lpRemove)
{
	BOOL	bResult = FALSE;
	DWORD	dwResult;
	TCHAR	szValueName[256];
	TCHAR	szDefIcon[512];

	dwResult = SHSetValue(HKEY_CLASSES_ROOT,lpSubKey,lpszNullString,REG_SZ,lpValue1,
						  lstrlen(lpValue1));
	if (dwResult != ERROR_SUCCESS)
	{
		SetLastError(dwResult);
		ErrorProcedure((LPTSTR)lpSubKey,IDS_REGSETVALUE,MB_OK);
		goto SetRegEnd;
	}
	dwResult = SHSetValue(HKEY_CLASSES_ROOT,lpValue1,lpszNullString,REG_SZ,lpValue2,
						  lstrlen(lpValue2));
	if (dwResult != ERROR_SUCCESS)
	{
		SetLastError(dwResult);
		ErrorProcedure((LPTSTR)lpValue1,IDS_REGSETVALUE,MB_OK);
		goto SetRegEnd;
	}
	// Setup the default icon value.
	//..............................
	ZeroMemory(&szValueName,sizeof(szValueName));
	ZeroMemory(&szDefIcon,sizeof(szDefIcon));

	StringCbCatEx((LPTSTR)&szValueName,sizeof(szValueName),lpValue1,NULL,NULL,
				   dwStringSafeFlag);
	StringCbCatEx((LPTSTR)&szValueName,sizeof(szValueName),lpszDefIcon,NULL,NULL,
				   dwStringSafeFlag);

	StringCbCatEx((LPTSTR)&szDefIcon,sizeof(szDefIcon),(LPCTSTR)&szTscPath,NULL,NULL,
				   dwStringSafeFlag);
	StringCbCatEx((LPTSTR)&szDefIcon,sizeof(szDefIcon),lpszIconFileName,NULL,NULL,
				   dwStringSafeFlag);
	StringCbCatEx((LPTSTR)&szDefIcon,sizeof(szDefIcon),lpIconNumber,NULL,NULL,
				   dwStringSafeFlag);

	dwResult = SHSetValue(HKEY_CLASSES_ROOT,(LPCTSTR)&szValueName,lpszNullString,REG_SZ,
						  (LPCVOID)&szDefIcon,lstrlen((LPCTSTR)&szDefIcon));
	if (dwResult != ERROR_SUCCESS)
	{
		SetLastError(dwResult);
		ErrorProcedure((LPTSTR)&szValueName,IDS_REGSETVALUE,MB_OK);
		goto SetRegEnd;
	}
	bResult = TRUE;
	*lpRemove = TRUE;

	SetRegEnd:

	return(bResult);
}

// Delete registry entry.
//.......................
VOID DeleteRegistryEntry(LPCTSTR lpSubKey1, LPCTSTR lpSubKey2, BOOL bRemove)
{
	if (bRemove)
	{
		SHDeleteKey(HKEY_CLASSES_ROOT,lpSubKey2);
		SHDeleteKey(HKEY_CLASSES_ROOT,lpSubKey1);
	}
}
